/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.ui;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.logon.LogonEvent;
import com.ibm.hwmca.fw.logon.LogonListener;
import com.ibm.hwmca.fw.logon.LogonManager;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.Status;
import com.ibm.hwmca.fw.managed.UnacceptableManagedObjects;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.settings.user.DefaultUserSettings;
import com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.Tasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.ui.UIEventQueue;
import com.ibm.hwmca.fw.ui.UILog;
import com.ibm.hwmca.fw.ui.UIObjectsConstants;
import com.ibm.hwmca.fw.ui.UIObjectsWriter;
import com.ibm.hwmca.fw.ui.UIPropertyChangeEvent;
import com.ibm.hwmca.fw.ui.UITaskletRequests;
import com.ibm.hwmca.fw.ui.UITaskletResponses;
import com.ibm.hwmca.fw.util.ShortObjectIdManager;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UIEventTasklet
extends Tasklet
implements PropertyChangeListener,
LogonListener,
UITaskletRequests,
UITaskletResponses,
UILog,
UIObjectsConstants {
    private Object waitLock = new Object();
    private UIEventQueue queue;
    private boolean stopLoop = false;
    private static int nextTaskletId = 1;
    private static Map tasklets = new HashMap();
    private ObjectId momObjectId;
    private User user;
    private UserContext uc = UserContext.getCurrentUserContext();
    private int numStatusShortIds = 0;
    private int numAttnTaskShortIds = 0;
    private static final String TRACE_MASKT = "HUITSKLT";
    private static final String TRACE_MASKF = "HUITSKLF";
    private static final String TRACE_MASKD = "HUITSKLD";

    public UIEventTasklet() throws HException {
        if (!this.uc.isAuthenticated()) {
            String s = "User context is not authenticated!  Current user context is:\n" + this.uc;
            Trace.trace(TRACE_MASKT, s);
            HException hexc = new HException(s);
            new FrameworkLog(UILog.logInfo, 1792, hexc).log();
            throw hexc;
        }
    }

    public void init(Object obj) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.init()");
        this.user = User.getUser();
        LogonManager.getLogonManager().addLogonListener(this, this.uc);
        this.queue = new UIEventQueue();
        this.momObjectId = ManagedObjectManager.getManagedObjectManager().getObjectId();
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.init()");
    }

    public void service(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.service()");
        if (request.isInitialRequest()) {
            Trace.trace(TRACE_MASKT, "   processing initial request");
            UnacceptableManagedObjects umo = UnacceptableManagedObjects.getUnacceptableManagedObjects();
            umo.addPropertyChangeListener(this, "StateProperty");
            UIObjectsWriter writer = UIObjectsWriter.getUIObjectsWriter();
            writer.addPropertyChangeListener(this);
            this.user.addPropertyChangeListener("UserSettings", this);
            Map userSettings = this.user.getAllUserSettings();
            Map map = this.getAttentionTaskImageNameMap(userSettings);
            response.setData("AttnTaskImageNames", map);
            this.numAttnTaskShortIds = map.size();
            map = this.getStatusImageNameMap(userSettings);
            response.setData("StatusImageNames", map);
            this.numStatusShortIds = map.size();
            response.setData("UserSettings", userSettings);
            response.setData("AllowedShortIds", writer.getAllowedShortIds());
            response.setData("UnacceptableState", new Boolean(umo.isUnacceptable()));
            response.setData("TaskletId", this.getNextTaskletId());
            response.setData("UIActions", writer.getUIActions());
            DefaultUserSettings.getDefaultUserSettings();
            response.setData("BackgroundImageName", DefaultUserSettings.getUIBackgroundImageName());
            response.setData("ShortIdToStatus", writer.getShortIdToStatus());
            response.setData("StatusToShortId", writer.getStatusToShortId());
            response.noAction();
        } else {
            String requestKey = (String)request.getData("UIRequestKey");
            Trace.trace(TRACE_MASKF, "   requestKey is [" + requestKey + "]");
            if (requestKey.equals("GetEvents")) {
                this.serviceGetEvents(request, response);
            } else if (requestKey.equals("GetObjectIdMap")) {
                ShortObjectIdManager shortIdManager = UIObjectsWriter.getUIObjectsWriter().getShortObjectIdManager();
                Set shortIds = (Set)request.getData("ShortIdSet");
                Map objectIds = shortIdManager.getObjectIds(shortIds);
                response.setData("ObjectIdMap", objectIds);
                response.noAction();
            } else if (requestKey.equals("GetTaskClassName")) {
                ObjectId objectId = (ObjectId)request.getData("ObjectId");
                ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                String className = (String)mom.getProperty(objectId, "PresentationTaskClassName");
                response.setData("TaskClassName", className);
                response.noAction();
            } else {
                Trace.trace(TRACE_MASKF, "   Error, unknown request was received");
                response.noAction();
            }
        }
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.service()");
    }

    private Map getStatusImageNameMap(Map userSettings) {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.getStatusImageNameMap()");
        HashMap<String, String> imageNames = new HashMap<String, String>();
        ObjectBackgroundSettings backgroundSettings = (ObjectBackgroundSettings)userSettings.get("com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings");
        UIObjectsWriter writer = UIObjectsWriter.getUIObjectsWriter();
        Map shortIds = writer.getStatusToShortId();
        Trace.trace(TRACE_MASKD, "   number in statusToShortIds map is " + shortIds.size());
        Iterator iterator = shortIds.keySet().iterator();
        while (iterator.hasNext()) {
            Status status = (Status)iterator.next();
            String shortId = (String)shortIds.get(status);
            String imageName = backgroundSettings.getBackgroundImageName(status);
            Trace.trace(TRACE_MASKD, "   next status is " + status + ", status.hashCode() is " + status.hashCode() + ", shortId is " + shortId + ", image name is " + imageName);
            if (imageName == null) continue;
            imageNames.put(shortId, imageName);
        }
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.getStatusImageNameMap()");
        return imageNames;
    }

    private Map getAttentionTaskImageNameMap(Map userSettings) {
        Trace.trace(TRACE_MASKF, "-> UIEventTasklet.getAttentionTaskImageNameMap()");
        HashMap<String, String> imageNames = new HashMap<String, String>();
        ObjectBackgroundSettings backgroundSettings = (ObjectBackgroundSettings)userSettings.get("com.ibm.hwmca.fw.settings.user.ObjectBackgroundSettings");
        UIObjectsWriter writer = UIObjectsWriter.getUIObjectsWriter();
        Map shortIds = writer.getAttentionTaskShortIds();
        Trace.trace(TRACE_MASKF, "   number of attention task shortids is " + shortIds.size());
        Iterator iterator = shortIds.keySet().iterator();
        while (iterator.hasNext()) {
            ObjectId objectId = (ObjectId)iterator.next();
            imageNames.put((String)shortIds.get(objectId), backgroundSettings.getAttentionImageName(objectId));
        }
        Trace.trace(TRACE_MASKF, "<- UIEventTasklet.getAttentionTaskImageNameMap()");
        return imageNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceGetEvents(TaskletRequest request, TaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.serviceGetEvents()");
        Object object = this.waitLock;
        synchronized (object) {
            while (!this.stopLoop && this.queue.size() == 0) {
                try {
                    Trace.trace(TRACE_MASKF, "   waiting...");
                    this.waitLock.wait();
                }
                catch (InterruptedException exc) {}
            }
            Trace.trace(TRACE_MASKF, "   UIEventTasklet woke up");
        }
        if (this.stopLoop) {
            Trace.trace(TRACE_MASKF, "   UIEventTasklet is stopping");
            UnacceptableManagedObjects umo = UnacceptableManagedObjects.getUnacceptableManagedObjects();
            umo.removePropertyChangeListener(this);
            this.user.removePropertyChangeListener(this);
            UIObjectsWriter.getUIObjectsWriter().removePropertyChangeListener(this);
            LogonManager.getLogonManager().removeLogonListener(this, this.uc);
            this.queue.clear();
            response.setData("Logoff", "LogOff");
        } else {
            List events = this.queue.get(true);
            Trace.trace(TRACE_MASKF, "   there are " + events.size() + " event(s) in the queue");
            response.setData("Events", events);
        }
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.serviceGetEvents()");
        response.noAction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Integer getNextTaskletId() {
        Integer result = null;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            result = new Integer(nextTaskletId);
            tasklets.put(result, this);
            ++nextTaskletId;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopLoop() {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.stopLoop()");
        Object object = this.waitLock;
        synchronized (object) {
            this.stopLoop = true;
            this.waitLock.notify();
        }
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.stopLoop()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.propertyChange()");
        Trace.trace(TRACE_MASKD, "   source is " + evt.getSource());
        Trace.trace(TRACE_MASKD, "   property name is " + evt.getPropertyName());
        if (!this.stopLoop) {
            UIPropertyChangeEvent uiEvent = null;
            if (evt instanceof UIPropertyChangeEvent) {
                Map userSettings;
                uiEvent = (UIPropertyChangeEvent)evt;
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                UIObjectsWriter writer = UIObjectsWriter.getUIObjectsWriter();
                Map map = writer.getStatusToShortId();
                if (this.numStatusShortIds != map.size()) {
                    this.numStatusShortIds = map.size();
                    userSettings = this.user.getAllUserSettings();
                    map = this.getStatusImageNameMap(userSettings);
                    this.queue.add(new UIPropertyChangeEvent("UIEventTasklet", "StatusImages", null, map));
                }
                if (oldValue == null && newValue != null && evt.getPropertyName().equals("InventoryProperty")) {
                    Trace.trace(TRACE_MASKD, "   this is an inventory add event");
                    map = writer.getAttentionTaskShortIds();
                    Trace.trace(TRACE_MASKD, "   numAttnTaskShortIds is " + this.numAttnTaskShortIds);
                    Trace.trace(TRACE_MASKD, "   map.size() is " + map.size());
                    if (this.numAttnTaskShortIds != map.size()) {
                        this.numAttnTaskShortIds = map.size();
                        userSettings = this.user.getAllUserSettings();
                        map = this.getAttentionTaskImageNameMap(userSettings);
                        this.queue.add(new UIPropertyChangeEvent("UIEventTasklet", "AttnTaskImages", null, map));
                    }
                }
            } else {
                String propertyName = evt.getPropertyName();
                if (propertyName.equals("UserSettings")) {
                    if (evt.getNewValue() instanceof ObjectBackgroundSettings) {
                        Map userSettings = this.user.getAllUserSettings();
                        Map map = this.getAttentionTaskImageNameMap(userSettings);
                        this.queue.add(new UIPropertyChangeEvent("UIEventTasklet", "AttnTaskImages", null, map));
                        map = this.getStatusImageNameMap(userSettings);
                        this.queue.add(new UIPropertyChangeEvent("UIEventTasklet", "StatusImages", null, map));
                    }
                    uiEvent = new UIPropertyChangeEvent(evt);
                } else {
                    uiEvent = new UIPropertyChangeEvent(evt);
                }
            }
            this.queue.add(uiEvent);
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.propertyChange()");
    }

    public void loggedOff(LogonEvent event) {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.loggedOff()");
        this.stopLoop();
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.loggedOff()");
    }

    public void loggedOn(LogonEvent event) {
    }

    public void disconnected(LogonEvent event) {
        Trace.trace(TRACE_MASKT, "-> UIEventTasklet.disconnected()");
        Trace.trace(TRACE_MASKT, "<- UIEventTasklet.disconnected()");
    }

    public void reconnected(LogonEvent event) {
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "Error in UIEventTasklet.logException(): " + throwable);
        new FrameworkLog(UILog.logInfo, 1793, throwable).log();
    }
}

